/*==============================================================================
 MASTER ANALYSIS
==============================================================================
Purpose:
Executes all analysis steps sequentially to generate tables and figures 
for the paper. This master file coordinates the execution of individual 
analysis modules.

Note: Some dofiles are used several times under different global variables, in particular for extensions.
Such dofile have an explicit name that refer to the type of figure or table they generate, e.g. deposit_beta_vs_uninsured_share etc.
Other dofiles are used only once, and their name refer directly to the figure or table they generate, e.g. table1_estimation_inputs, etc.

Structure:
- Data Loading
- Figure Generation
- Table Generation

Input:  analysis_ready_data.dta from Part 2
Output: Tables (.tex) and Figures (.pdf) in the output directory

Last updated: July 03, 2025
==============================================================================*/

clear all
display "==================================================================="
display "                   MASTER ANALYSIS"
display "==================================================================="

//==============================================================================
// Data Loading
//==============================================================================
display "--- Starting Data Loading ---"

// Load the dataset containing all constructed variables
use "$path_clean/analysis_ready_data.dta", clear

display "--- Data Loading completed ---"

//==============================================================================
// Figure Generation
//==============================================================================
display "--- Starting Figure Generation ---"

// Generate Figure 7 (Specific figure related to analysis)
do "$path_code/03_analysis/deposit_beta_vs_uninsured_share.do"

// Generate Figure 8 (Specific figure related to analysis)
do "$path_code/03_analysis/binned_scatter_bank_values.do"

// Generate Figure 9 (Specific figure related to analysis)
do "$path_code/03_analysis/scatter_bank_values_with_annotations.do"

display "--- Figure Generation completed ---"

//==============================================================================
// Main tables Generation
//==============================================================================
display "--- Starting Table Generation ---"

// Generate Table 1: Estimation Inputs
do "$path_code/03_analysis/table1_estimation_inputs.do"

// Generate Table 2: Bank Values
do "$path_code/03_analysis/summary_statistics_bank_valuations.do"

// for table A1 we need to load the clean call reports data
preserve
use "$path_clean/call_reports_prepared.dta", clear
sort rssdid yq
tsset rssdid yq
// Generate Table A1: Summary Statistics
do "$path_code/03_analysis/tableA1_summary_statistics.do"
restore

// Generate Table A2: Deposit Betas
do "$path_code/03_analysis/tableA2_deposit_betas.do"

// Generate Table A3: Deposit Costs
do "$path_code/03_analysis/tableA3_deposit_costs.do"

// Generate Table A4: Deposit Franchise
do "$path_code/03_analysis/tableA4_deposit_franchise.do"

display "--- Table Generation completed ---"

display "==================================================================="
display "               ANALYSIS COMPLETED SUCCESSFULLY"
display "==================================================================="
